/*
 * VRT RULES
 * 
 * Copyright (C) 2005 Sourcefire, Inc.
 * 
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>

XXX DOES NOT USE BUILT-IN DETECTION FUNCTIONS!!
alert tcp $EXTERNAL_NET $HTTP_PORTS -> $HOME_NET any (msg:"WEB-CLIENT Microsoft Excel sst record arbitrary code execution attempt"; flow:from_server,established; flowbits:isset,file.xls; content:"|fc 00|"; byte_test:1,&,4,12,relative; reference:url,technet.microsoft.com/en-us/security/bulletin/MS08-014; reference:cve,2008-0116; classtype:attempted-user; sid:13570; rev:1;)


 */


#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"

//#define DEBUG
#ifdef DEBUG
#define DEBUG_WRAP(code) code
#else
#define DEBUG_WRAP(code)
#endif

/* declare detection functions */
int rule13582eval(void *p);

/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */
/* flow:established, from_server; */
static FlowFlags rule13582flow0 = 
{
    FLOW_ESTABLISHED|FLOW_TO_CLIENT
};

static RuleOption rule13582option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule13582flow0
    }
};
/* flowbits:isset "file.xls"; */
static FlowBitsInfo rule13582flowbits1 =
{
    "file.xls",
    FLOWBIT_ISSET,
    0,
};

static RuleOption rule13582option1 =
{
    OPTION_TYPE_FLOWBIT,
    {
        &rule13582flowbits1
    }
};
// content:"|FC 00|"; 
static ContentInfo rule13582content2 = 
{
    (uint8_t *) "|FC 00|", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_BUF_NORMALIZED|CONTENT_RELATIVE, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule13582option2 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule13582content2
    }
};

/* references for sid 13582 */
/* reference: cve "2008-0116"; */
static RuleReference rule13582ref1 = 
{
    "cve", /* type */
    "2008-0116" /* value */
};

/* reference: url "technet.microsoft.com/en-us/security/bulletin/MS08-014"; */
static RuleReference rule13582ref2 = 
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/MS08-014" /* value */
};

static RuleReference *rule13582refs[] =
{
    &rule13582ref1,
    &rule13582ref2,
    NULL
};
/* metadata for sid 13582 */
/* metadata:; */
static RuleMetaData rule13582service1 =
{
    "service http"
};

static RuleMetaData rule13582policy1 =
{
   "policy max-detect-ips drop"
};

static RuleMetaData *rule13582metadata[] =
{
    &rule13582service1,
    &rule13582policy1,
    NULL
};
RuleOption *rule13582options[] =
{
    &rule13582option0,
    &rule13582option1,
    &rule13582option2,
    NULL
};

Rule rule13582 = {
   
   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "$HTTP_PORTS", /* SRCPORT   */
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "any", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid (HARDCODED!!!) */
       13582, /* sigid */
       13, /* revision */
   
       "attempted-user", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "FILE-OFFICE Microsoft Excel sst record arbitrary code execution attempt",     /* message */
       rule13582refs /* ptr to references */
       ,rule13582metadata
   },
   rule13582options, /* ptr to rule options */
   &rule13582eval, /* DOES NOT use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */
int rule13582eval(void *p) {
    const uint8_t *cursor_normal = 0;

    SFSnortPacket *sp = (SFSnortPacket *) p;
    const uint8_t *end_of_payload;
    
    uint32_t cch, cbExtRst;

    DEBUG_WRAP(char name[]="rule13582eval");
    DEBUG_WRAP(printf("%s: enter\n", name));

    if(sp == NULL || sp->payload == NULL)
       return RULE_NOMATCH;

    // flow:established, from_server;
    if (checkFlow(p, rule13582options[0]->option_u.flowFlags) <= 0 )
       return RULE_NOMATCH;

    // flowbits:isset "file.xls";
    if (processFlowbits(p, rule13582options[1]->option_u.flowBit) <= 0)
       return RULE_NOMATCH;

    // Set the cursor to the start of the payload so we can just loop
    // through using relative content matches
    if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &cursor_normal, &end_of_payload) <= 0)
       return RULE_NOMATCH;

    // Loop looking for the BIFF header and checking the values
    // content:"|FC 00|";
    while(contentMatch(p, rule13582options[2]->option_u.content, &cursor_normal) > 0) {
       DEBUG_WRAP(printf("%s: found |FC 00|\n", name));

       //Check that next two fields of 4 bytes are not negative with a bit test on the most significant bits
       if((cursor_normal[5] & 0x80) || (cursor_normal[9] & 0x80))
          return RULE_NOMATCH; 
 
       // byte_test:size 1, value 0xf2, operator &, offset 12, relative
       //  this byte contains the options flags for a unicode string. When the 2nd bit (fExtSt) is set and 
       // the third bit (fRichSt) is not, then the string following is an extended string and must be checked
       if ((cursor_normal[12] & 0xF6) != 0x04)
          return RULE_NOMATCH;

       DEBUG_WRAP(printf("%s: fExtSt bit is set\n", name));
    
       if(cursor_normal + 16 > end_of_payload)
          return RULE_NOMATCH;

       cbExtRst = cursor_normal[13];
       cbExtRst |= cursor_normal[14] << 8;
       cbExtRst |= cursor_normal[15] << 16;
       cbExtRst |= cursor_normal[16] << 24;

       DEBUG_WRAP(printf("%s: cbExtRst=%08p\n", name, cbExtRst));

       if(cbExtRst >= 0x80000000)
          return RULE_MATCH;

       cch = cursor_normal[10];
       cch |= cursor_normal[11] << 8;

       DEBUG_WRAP(printf("%s: cch=%04p\n", name, cch)); 

       if(cch * 2 + 6 + cbExtRst >= 0x80000000)
          return RULE_MATCH;
    }

    return RULE_NOMATCH;
}

/*
Rule *rules[] = {
    &rule13582,
    NULL
};
*/
